#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Strange TunnelMod01.fsh  by   Alkama
//https://www.shadertoy.com/view/WtySzK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float t = 0.;
const float pi = acos(-1.);
const mat3 yuv2rgb = mat3(1., 0., 1.13983, 1., -0.39465, -0.58060, 1., 2.03211, 0.);
mat2 rot(float a) { float c=cos(a),s=sin(a); return mat2(c,s,-s,c); } 
float cube(vec3 p, vec3 s) { vec3 b=abs(p)-s; return max(max(b.x,b.y),b.z); }
float torus(vec3 p, float l, float s) { return length(vec2(length(p.xz)-l, p.y))-s; }
vec2 scene(vec3 p) {
    p.y=mod(p.y,.5)-.25;
    p.xz *= rot((2.*pi+sin(t*2.))*2.*p.y);
    float s=1., r=0.;
    for(int i=0;i<3;i++) {
        p = 2.*clamp(p, -.1, .1)-p;
        r = max((.04*sin(t*5.)+.2)/dot(p,p), .9);
        p*=r; s*=r;
    }
    vec2 c = vec2(max(cube(p,vec3(.5)), -min(cube(p,vec3(.6,.45,.45)),min(cube(p,vec3(.45,.6,.45)), cube(p,vec3(.45,.45,.6))))), 1.);
    vec2 t = vec2(torus(p, 1., .05), 2.);
    t=t.x<c.x?t:c;
    return t*vec2(.3/s, 1.);
}
vec3 march(vec3 og, vec3 dir, int it, float tr, float md) {
    int i=0;
    float d=0.;
    vec3 p = og;
    for (i=0; i<it; i++) {
        vec2 t = scene(p);
        float h = t.x;
        if (h<tr*d) return vec3(d,i,t.y);
        if (d>md) return vec3(d,i,0);
        d += h;
        p += dir * h;
    }
    return vec3(d,i,0);
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord/iResolution.xy - 0.5) / vec2(iResolution.y / iResolution.x, 1);
    float tt = mod(.2*iTime,pi*2.);
	t = (tt+sin(tt*5.)*.18);
    vec3 eye = vec3(.03*sin(t*2.), t-.5, .03*cos(t));
    vec3 f = normalize(vec3(0,t,0)-eye);
    vec3 s = normalize(cross(vec3(0,1,1), f));
    vec3 u = normalize(cross(f,s));
    vec3 dir = normalize(f*(.55+sin(tt*5.)*.25)+uv.x*s+uv.y*u);
    vec3 lp = .2*vec3(sin(t),sin(t)+t,cos(t*1.5));
    vec3 col = vec3(0.);
    vec3 m = march(eye, dir, 200, .001, 2.);
    vec3 p = eye+dir*m.x;
    if (m.z > 0.) {
        vec2 e=vec2(.001,0);
        vec3 n = normalize(vec3(scene(p+e.xyy).x-scene(p-e.xyy).x,scene(p+e.yxy).x-scene(p-e.yxy).x,scene(p+e.yyx).x-scene(p-e.yyx).x));
        vec3 ld = normalize(lp - p);
        float diff=max(0.,dot(n,ld));
        float nd = dot(n,-dir);
        float spec=pow(max(0., nd),20.);
        float fres=1.-abs(nd);
        float ao = scene(p+n*.1).x/.1 + scene(p+n*.3).x/.3;
        vec3 acd = normalize(acos(-dir));
        if (m.z > 1.) {
            col = ao*.5+.15*fres*yuv2rgb*acd.zyx;
        } else {
            col = ao*0.2+.5*spec*acd.xzy;
        }
        col *= pow(max(0.,2.-length(p-vec3(0.,t,0.))),3.);
    }
    col *= pow(1.4-length(uv), 3.);
    fragColor = vec4(pow(col, vec3(1./2.2)),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

